/*
 * Decompiled with CFR 0.152.
 */
package jp.co.jpx.var.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import jp.co.jpx.var.common.OutputVmaVersion;
import jp.co.jpx.var.core.enumeration.MessageCode;
import jp.co.jpx.var.core.util.PropertyUtil;
import jp.co.jpx.var.gui.view.CalculationGui;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages={"jp.co.jpx.var.*"})
public class GuiApplication
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(GuiApplication.class);
    private String propertyFilePath = null;
    private Properties properties = new Properties();

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "false");
        SpringApplication.run(GuiApplication.class, (String[])args);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void run(ApplicationArguments args) {
        block19: {
            try {
                OutputVmaVersion.getInstance().outVmaVersionToLog();
                String reqId = UUID.randomUUID().toString();
                MDC.put((String)"req-id", (String)reqId);
                String dirCalProp = PropertyUtil.getPropertyParam((String)"var.gui.property");
                String jarPath = null;
                if (dirCalProp == null) {
                    jarPath = System.getProperty("java.class.path");
                    dirCalProp = jarPath.substring(0, jarPath.lastIndexOf(File.separator) + 1);
                    this.propertyFilePath = dirCalProp + "calculation.properties";
                } else {
                    this.propertyFilePath = dirCalProp + "/" + "calculation.properties";
                }
                CalculationGui calculationGui = new CalculationGui(this.propertyFilePath, reqId);
                calculationGui.setVisible(false);
                File pFile = new File(this.propertyFilePath);
                if (!pFile.exists()) break block19;
                try (FileInputStream fileInputStream = new FileInputStream(this.propertyFilePath);){
                    this.properties.load(fileInputStream);
                    for (Map.Entry<Object, Object> propMap : this.properties.entrySet()) {
                        String propertyKey = propMap.getKey().toString();
                        String propertyValue = propMap.getValue().toString();
                        CalculationGui.getPropertyMap().put(propertyKey, propertyValue);
                    }
                    calculationGui.getPositionFileText().setText((String)CalculationGui.getPropertyMap().get("PositionFileKey"));
                    calculationGui.getInputFilesFolderText().setText((String)CalculationGui.getPropertyMap().get("InputFilesFolderKey"));
                    calculationGui.getOutputFileFolderText().setText((String)CalculationGui.getPropertyMap().get("OutputFileFolderKey"));
                }
                catch (IOException io) {
                    log.error(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_ERROR_ES000, (Object[])new Object[0]));
                    log.error(io.getMessage(), (Throwable)io);
                }
            }
            catch (Exception e) {
                log.error(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_ERROR_ES000, (Object[])new Object[0]));
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

