/*
 * Decompiled with CFR 0.152.
 */
package jp.co.jpx.var.gui.controller;

import java.rmi.server.UID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.co.jpx.var.common.inputcheck.ComInputCheck;
import jp.co.jpx.var.core.coordinator.IGuiCliCoordinator;
import jp.co.jpx.var.core.coordinator.dto.CheckOutDto;
import jp.co.jpx.var.core.coordinator.dto.InputDto;
import jp.co.jpx.var.core.coordinator.dto.MessageDto;
import jp.co.jpx.var.core.enumeration.MessageCode;
import jp.co.jpx.var.core.exception.BusinessSystemException;
import jp.co.jpx.var.core.exception.ServiceSystemException;
import jp.co.jpx.var.core.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GUIController {
    private static final Logger log = LoggerFactory.getLogger(GUIController.class);
    @Autowired
    private IGuiCliCoordinator iGuiCliCoordinator;

    public CheckOutDto exec(InputDto guiInputDto) {
        CheckOutDto checkOutDto = new CheckOutDto();
        checkOutDto.setMessageList(new ArrayList());
        log.info(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_INFO_I0064, (Object[])new Object[0]));
        try {
            if ("".equals(guiInputDto.getOutputFileName())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                String date = dateFormat.format(new Date());
                String uid = new UID().toString().substring(0, 4);
                String outputFileName = "MarginResult_" + date + "_" + uid + ".csv";
                guiInputDto.setOutputFileName(outputFileName);
            }
            if ((checkOutDto = ComInputCheck.getInstance().checkPrm(1, guiInputDto)).getRetFlag() == 0) {
                checkOutDto = this.iGuiCliCoordinator.execGuiCliCoordinator(guiInputDto);
                if (checkOutDto.getRetFlag() != 0) {
                    checkOutDto.getMessageList().add(0, new MessageDto(MessageCode.ENUM_ERROR_ES060, new Object[0]));
                    this.setErrorLogFileInfo(guiInputDto, checkOutDto.getMessageList());
                }
            } else {
                checkOutDto.getMessageList().add(0, new MessageDto(MessageCode.ENUM_ERROR_ES060, new Object[0]));
                this.setErrorLogFileInfo(guiInputDto, checkOutDto.getMessageList());
            }
        }
        catch (ServiceSystemException e) {
            ArrayList<MessageDto> messageList = new ArrayList<MessageDto>(e.getErrorMessageList());
            messageList.add(0, new MessageDto(MessageCode.ENUM_ERROR_ES060, new Object[0]));
            this.setErrorLogFileInfo(guiInputDto, messageList);
            checkOutDto.setRetFlag(1);
            if (null == checkOutDto.getMessageList()) {
                checkOutDto.setMessageList(new ArrayList());
            } else {
                checkOutDto.getMessageList().clear();
            }
            checkOutDto.getMessageList().addAll(messageList);
        }
        catch (BusinessSystemException e) {
            checkOutDto.getMessageList().add(0, new MessageDto(MessageCode.ENUM_ERROR_ES000, new Object[0]));
        }
        catch (OutOfMemoryError e) {
            log.error(e.toString());
            if (null != checkOutDto.getMessageList()) {
                checkOutDto.getMessageList().clear();
            } else {
                checkOutDto.setMessageList(new ArrayList());
            }
            checkOutDto.setRetFlag(1);
            checkOutDto.getMessageList().add(0, new MessageDto(MessageCode.ENUM_ERROR_ES001, new Object[0]));
        }
        catch (Exception e) {
            log.error(e.toString());
            if (null != checkOutDto.getMessageList()) {
                checkOutDto.getMessageList().clear();
            } else {
                checkOutDto.setMessageList(new ArrayList());
            }
            checkOutDto.setRetFlag(1);
            checkOutDto.getMessageList().add(0, new MessageDto(MessageCode.ENUM_ERROR_ES000, new Object[0]));
        }
        log.info(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_INFO_I0065, (Object[])new Object[0]));
        return checkOutDto;
    }

    private void setErrorLogFileInfo(InputDto guiInputDto, List<MessageDto> errorMessageList) {
        String errorLogFileName;
        ArrayList<MessageDto> messageList = new ArrayList<MessageDto>(errorMessageList);
        String fileName = guiInputDto.getOutputFileName();
        if (fileName.indexOf(".") != -1) {
            int lastDot = fileName.lastIndexOf(".");
            errorLogFileName = "Error_" + fileName.substring(0, lastDot) + ".log";
        } else {
            errorLogFileName = "Error_" + fileName + ".log";
        }
        ComInputCheck.getInstance().makeErrorLogFile(guiInputDto.getOutputFolder(), errorLogFileName, messageList);
    }
}

