/*
 * Decompiled with CFR 0.152.
 */
package jp.co.jpx.var.gui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.co.jpx.var.gui.constant.CommonGuiConstant;
import jp.co.jpx.var.gui.view.CalculationCalendar;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculationCalendar
extends JPanel {
    private transient ClassLoader cl = this.getClass().getClassLoader();
    private ImageIcon appImageIcon = new ImageIcon(this.cl.getResource("guiImageResources/app_icon.png"));
    private transient Image appIconImage = this.appImageIcon.getImage();
    private JComboBox<Integer> yearCombo = new JComboBox();
    private JComboBox<Object> monthCombo = new JComboBox<Object>(new Object[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12});
    private transient ItemListener yearComboItemListener;
    private transient ItemListener monthComboItemListener;
    private JPanel calendarPanel;
    private ArrayList<String> dayLabelList = new ArrayList();
    private ArrayList<DateLabel> labelList = new ArrayList();
    private LocalDate operateResultTime = null;
    private LocalDate fixedInputDate = null;
    private LocalDate clickDate;

    public static LocalDate showCalendarDialog(Window owner, LocalDate inputDate) {
        JDialog calendarDialog = new JDialog(owner, "JSCC VaR Margin Application Calendar");
        calendarDialog.setSize(300, 250);
        calendarDialog.setLocationRelativeTo(null);
        calendarDialog.setResizable(false);
        return CalculationCalendar.adjustmentCalendarDialog((JDialog)calendarDialog, (LocalDate)inputDate);
    }

    private static LocalDate adjustmentCalendarDialog(JDialog calendarDialog, LocalDate inputDate) {
        CalculationCalendar calculationCalendar = new CalculationCalendar(calendarDialog, inputDate);
        calculationCalendar.addComponentListener((ComponentListener)new /* Unavailable Anonymous Inner Class!! */.setOwner(calendarDialog));
        calendarDialog.add((Component)calculationCalendar);
        calendarDialog.setModal(true);
        calendarDialog.setVisible(true);
        LocalDate returnDate = calculationCalendar.getClickDate();
        return returnDate;
    }

    CalculationCalendar(JDialog calendarDialog, LocalDate inputDate) {
        JPanel dateChangeComponentPanel = new JPanel();
        dateChangeComponentPanel.setPreferredSize(new Dimension(245, 32));
        JButton nextButton = new JButton(">>");
        nextButton.addActionListener(e -> {
            this.operateResultTime = this.operateResultTime.plusMonths(1L);
            this.setCalendar(this.operateResultTime);
        });
        JButton prevButton = new JButton("<<");
        prevButton.addActionListener(e -> {
            this.operateResultTime = this.operateResultTime.minusMonths(1L);
            this.setCalendar(this.operateResultTime);
        });
        DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
        if (null == inputDate) {
            inputDate = LocalDate.now();
        }
        this.fixedInputDate = inputDate;
        this.operateResultTime = inputDate;
        int comboMinYear = this.operateResultTime.getYear() - 3;
        for (int i = 0; i < 7; ++i) {
            model.addElement(comboMinYear);
            ++comboMinYear;
        }
        this.yearCombo.setModel(model);
        this.yearCombo.setFont(new Font("Arial", 1, 13));
        this.monthCombo.setFont(new Font("Arial", 1, 13));
        this.yearComboItemListener = e -> {
            if (e.getStateChange() == 1) {
                this.setCalendarFromComboBox();
            }
        };
        this.monthComboItemListener = e -> {
            if (e.getStateChange() == 1) {
                this.setCalendarFromComboBox();
            }
        };
        this.yearCombo.addItemListener(this.yearComboItemListener);
        this.monthCombo.addItemListener(this.monthComboItemListener);
        dateChangeComponentPanel.add(prevButton);
        dateChangeComponentPanel.add(this.yearCombo);
        dateChangeComponentPanel.add(new JLabel("-"));
        dateChangeComponentPanel.add(this.monthCombo);
        dateChangeComponentPanel.add(new JLabel(" "));
        dateChangeComponentPanel.add(nextButton);
        this.add((Component)dateChangeComponentPanel);
        this.setCalendar(this.operateResultTime);
        dateChangeComponentPanel.setVisible(true);
        calendarDialog.setIconImage(this.appIconImage);
    }

    private void setCalendarFromComboBox() {
        int newMonth = (Integer)this.monthCombo.getSelectedItem();
        int newYear = (Integer)this.yearCombo.getSelectedItem();
        this.operateResultTime = LocalDate.of(newYear, newMonth, this.operateResultTime.getDayOfMonth());
        this.setCalendar(this.operateResultTime);
    }

    private void setCalendar(LocalDate operateResultTime) {
        if (null == this.calendarPanel) {
            this.createCalendarPanel();
        }
        this.setComboBox(operateResultTime);
        LocalDate dateForCreateCalendar = LocalDate.of(operateResultTime.getYear(), operateResultTime.getMonth(), 1);
        if (dateForCreateCalendar.getDayOfWeek().getValue() < 4) {
            dateForCreateCalendar = dateForCreateCalendar.minusDays(dateForCreateCalendar.getDayOfWeek().getValue());
            dateForCreateCalendar = dateForCreateCalendar.minusDays(7L);
        } else {
            dateForCreateCalendar = dateForCreateCalendar.minusDays(dateForCreateCalendar.getDayOfWeek().getValue());
        }
        Color monToSatColor = CommonGuiConstant.COLOR_GRAY;
        Color sundayColor = CommonGuiConstant.COLOR_PINK;
        for (int i = 0; i < 42; ++i) {
            DateLabel dateLabel = (DateLabel)this.labelList.get(i);
            dateLabel.setText("" + dateForCreateCalendar.getDayOfMonth());
            dateLabel.setFont(new Font("Arial", 1, 13));
            if (i < 11 && dateForCreateCalendar.getDayOfMonth() == 1) {
                monToSatColor = CommonGuiConstant.COLOR_BLACK;
                sundayColor = CommonGuiConstant.COLOR_RED;
            }
            if (i > 31 && dateForCreateCalendar.getDayOfMonth() == 1) {
                monToSatColor = CommonGuiConstant.COLOR_GRAY;
                sundayColor = CommonGuiConstant.COLOR_PINK;
            }
            if (dateForCreateCalendar.getDayOfWeek().getValue() == 7) {
                dateLabel.setForeground(sundayColor);
            } else {
                dateLabel.setForeground(monToSatColor);
            }
            if (dateForCreateCalendar.isEqual(this.fixedInputDate)) {
                dateLabel.setBackground(CommonGuiConstant.INPUT_DATE_COLOR);
            } else {
                dateLabel.setBackground(null);
            }
            DateLabel.access$002((DateLabel)dateLabel, (LocalDate)dateForCreateCalendar);
            dateForCreateCalendar = dateForCreateCalendar.plusDays(1L);
        }
    }

    private JPanel createCalendarPanel() {
        JPanel dateCalendarPanel = new JPanel();
        dateCalendarPanel.setPreferredSize(new Dimension(245, 165));
        this.dayLabelList.add("Sun");
        this.dayLabelList.add("Mon");
        this.dayLabelList.add("Tue");
        this.dayLabelList.add("Wed");
        this.dayLabelList.add("Thu");
        this.dayLabelList.add("Fri");
        this.dayLabelList.add("Sat");
        for (String dayOfWeek : this.dayLabelList) {
            JLabel dayLabel = new JLabel(dayOfWeek);
            dayLabel.setFont(new Font("Arial", 1, 13));
            dayLabel.setPreferredSize(new Dimension(30, 18));
            dayLabel.setHorizontalAlignment(4);
            dateCalendarPanel.add(dayLabel);
        }
        for (int i = 0; i < 42; ++i) {
            DateLabel dateLabel = new DateLabel(this);
            dateLabel.setPreferredSize(new Dimension(30, 18));
            dateLabel.setHorizontalAlignment(4);
            dateLabel.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */.setParam(dateLabel));
            dateLabel.setOpaque(true);
            dateCalendarPanel.add((Component)dateLabel);
            this.labelList.add(dateLabel);
        }
        this.add((Component)dateCalendarPanel);
        this.calendarPanel = dateCalendarPanel;
        return this.calendarPanel;
    }

    private void setComboBox(LocalDate operateResultTime) {
        int selectedMonth = operateResultTime.getMonth().getValue();
        int selectedYear = operateResultTime.getYear();
        this.yearCombo.removeItemListener(this.yearComboItemListener);
        this.monthCombo.removeItemListener(this.monthComboItemListener);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.yearCombo.getModel();
        int minComboElement = (Integer)model.getElementAt(0);
        int maxComboElement = (Integer)model.getElementAt(model.getSize() - 1);
        if (minComboElement >= selectedYear || maxComboElement <= selectedYear) {
            if (minComboElement >= selectedYear) {
                minComboElement = selectedYear - 3;
            }
            if (maxComboElement <= selectedYear) {
                maxComboElement = selectedYear + 3;
            }
            this.yearCombo.removeAllItems();
            for (int i = minComboElement; i <= maxComboElement; ++i) {
                this.yearCombo.addItem(i);
            }
        }
        this.yearCombo.setSelectedItem(selectedYear);
        this.monthCombo.setSelectedItem(selectedMonth);
        this.yearCombo.addItemListener(this.yearComboItemListener);
        this.monthCombo.addItemListener(this.monthComboItemListener);
    }

    private void setClickDate(LocalDate date) {
        this.clickDate = date;
        this.setVisible(false);
    }

    public LocalDate getClickDate() {
        return this.clickDate;
    }

    static /* synthetic */ void access$100(CalculationCalendar x0, LocalDate x1) {
        x0.setClickDate(x1);
    }

    static /* synthetic */ LocalDate access$200(CalculationCalendar x0) {
        return x0.fixedInputDate;
    }
}

