/*
 * Decompiled with CFR 0.152.
 */
package jp.co.jpx.var.gui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.co.jpx.var.common.OutputVmaVersion;
import jp.co.jpx.var.core.enumeration.MessageCode;
import jp.co.jpx.var.core.util.PropertyUtil;
import jp.co.jpx.var.gui.constant.CommonGuiConstant;
import jp.co.jpx.var.gui.view.CalculationGui;
import jp.co.jpx.var.gui.view.CalculationHelp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculationHelp
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(CalculationHelp.class);
    private transient ClassLoader cl = this.getClass().getClassLoader();
    private ImageIcon appImageIcon = new ImageIcon(this.cl.getResource("guiImageResources/app_icon.png"));
    private transient Image appIconImage = this.appImageIcon.getImage();
    private ImageIcon appTitleImageIcon = new ImageIcon(this.cl.getResource("guiImageResources/app_title_icon.png"));
    private ImageIcon calcGuiImageIcon = new ImageIcon(this.cl.getResource("guiImageResources/calculation_image.png"));
    private URL calcHelpItemDescription = this.cl.getResource("calcHelpItemDescription.html");

    CalculationHelp() {
        JFrame helpFrame = new JFrame("JSCC VaR Margin Application Help");
        helpFrame.setDefaultCloseOperation(2);
        helpFrame.setSize(1024, 768);
        helpFrame.setVisible(true);
        helpFrame.setIconImage(this.appIconImage);
        helpFrame.setExtendedState(6);
        int fullScreenPanelWidth = helpFrame.getWidth() - 100;
        if (fullScreenPanelWidth > 1835) {
            fullScreenPanelWidth = 1835;
        }
        if (fullScreenPanelWidth < 1485) {
            fullScreenPanelWidth = 1485;
        }
        JPanel helpHeaderPanel = new JPanel();
        this.setHeaderPanel(helpHeaderPanel);
        JPanel helpBodyPanel = new JPanel();
        this.setBodyPanel(helpBodyPanel, fullScreenPanelWidth);
        JPanel helpFooterPanel = new JPanel();
        this.setFooterPanel(helpFooterPanel);
        helpFrame.add((Component)helpHeaderPanel, "First");
        helpFrame.add((Component)helpBodyPanel, "Center");
        helpFrame.add((Component)helpFooterPanel, "Last");
    }

    private void setHeaderPanel(JPanel helpHeaderPanel) {
        JLabel appTitleImageIconLabel = new JLabel(this.appTitleImageIcon);
        appTitleImageIconLabel.setPreferredSize(new Dimension(320, 40));
        JLabel headerTitleLabel = new JLabel("VaR Margin Application Help");
        headerTitleLabel.setFont(new Font("Arial", 1, 24));
        headerTitleLabel.setForeground(CommonGuiConstant.COLOR_WHITE);
        helpHeaderPanel.setBackground(CommonGuiConstant.COLOR_BLACK);
        helpHeaderPanel.setLayout(new FlowLayout(0));
        helpHeaderPanel.add(appTitleImageIconLabel);
        helpHeaderPanel.add(headerTitleLabel);
    }

    private void setBodyPanel(JPanel helpBodyPanel, int fullScreenPanelWidth) {
        JPanel helpMainPanel = new JPanel();
        JPanel howToUseMainPanel = new JPanel();
        JPanel inCaseOfErrorMainPanel = new JPanel();
        JPanel usePanel = new JPanel();
        JPanel errorTablePanel = new JPanel();
        JLabel howToUseLabel = new JLabel("How to use");
        howToUseLabel.setFont(new Font("Arial", 1, 26));
        howToUseLabel.setPreferredSize(new Dimension(fullScreenPanelWidth, 35));
        JLabel inCaseOfErrorLabel = new JLabel("In case of Error");
        inCaseOfErrorLabel.setFont(new Font("Arial", 1, 26));
        inCaseOfErrorLabel.setPreferredSize(new Dimension(fullScreenPanelWidth, 35));
        JPanel itemDescriptionPanel = new JPanel();
        int calcHelpHtmlWidth = fullScreenPanelWidth - 835 - 50 - 100;
        this.setItemDescriptionPanel(itemDescriptionPanel, calcHelpHtmlWidth);
        int itemDescriptionPanelHeight = (int)itemDescriptionPanel.getPreferredSize().getHeight();
        itemDescriptionPanel.setBackground(CommonGuiConstant.COLOR_WHITE);
        JPanel calcGuiImagePanel = new JPanel();
        JLabel calcGuiImageLabel = new JLabel(this.calcGuiImageIcon);
        calcGuiImagePanel.add(calcGuiImageLabel);
        calcGuiImagePanel.setPreferredSize(new Dimension(835, itemDescriptionPanelHeight));
        calcGuiImagePanel.setBackground(CommonGuiConstant.COLOR_WHITE);
        usePanel.setPreferredSize(new Dimension(fullScreenPanelWidth, itemDescriptionPanelHeight));
        usePanel.setLayout(new FlowLayout(0, 50, 0));
        usePanel.add(calcGuiImagePanel);
        usePanel.add(itemDescriptionPanel);
        usePanel.setBackground(CommonGuiConstant.COLOR_WHITE);
        int howToUseMainPanelHeight = 35 + itemDescriptionPanelHeight;
        howToUseMainPanel.setPreferredSize(new Dimension(fullScreenPanelWidth, howToUseMainPanelHeight));
        howToUseMainPanel.add(howToUseLabel);
        howToUseMainPanel.add(usePanel);
        howToUseMainPanel.setBackground(CommonGuiConstant.COLOR_WHITE);
        Object[][] errorTableMessageData = new String[169][];
        try (InputStream is = this.getClass().getResourceAsStream("/calcHelpErrorMessage.tsv");
             BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            int index = 0;
            while ((line = br.readLine()) != null) {
                errorTableMessageData[index] = line.split("\\t");
                ++index;
            }
        }
        catch (Exception e) {
            CalculationGui.getMessageLogTextArea().setForeground(CommonGuiConstant.COLOR_RED);
            CalculationGui.getMessageLogTextArea().append(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_ERROR_ES000, (Object[])null) + "\n");
            log.error(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_ERROR_ES000, (Object[])new Object[0]));
            log.error(e.getMessage(), (Throwable)e);
        }
        JTable inCaseOfErrorTable = new JTable(errorTableMessageData, CommonGuiConstant.ERROR_TABLE_COLUMN);
        inCaseOfErrorTable.setEnabled(false);
        inCaseOfErrorTable.getTableHeader().setReorderingAllowed(false);
        TextAreaCellRenderer renderer = new TextAreaCellRenderer(this);
        TableColumnModel tcm = inCaseOfErrorTable.getColumnModel();
        for (int i = 0; i < 4; ++i) {
            tcm.getColumn(i).setCellRenderer((TableCellRenderer)renderer);
        }
        DefaultTableColumnModel errorTableColumnModel = (DefaultTableColumnModel)inCaseOfErrorTable.getColumnModel();
        TableColumn tableColumn = null;
        for (int i = 0; i < errorTableColumnModel.getColumnCount(); ++i) {
            tableColumn = errorTableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(545);
        }
        errorTableColumnModel.getColumn(0).setPreferredWidth(150);
        int finalColumnNo = errorTableColumnModel.getColumnCount() - 1;
        errorTableColumnModel.getColumn(finalColumnNo).setPreferredWidth(545 - (1835 - fullScreenPanelWidth));
        inCaseOfErrorTable.setRowHeight(55);
        inCaseOfErrorTable.setFont(new Font("Arial", 0, 12));
        inCaseOfErrorTable.setBorder(BorderFactory.createLineBorder(CommonGuiConstant.COLOR_BLACK));
        JTableHeader inCaseOfErrorTableHeader = inCaseOfErrorTable.getTableHeader();
        inCaseOfErrorTableHeader.setFont(new Font("Arial", 1, 18));
        inCaseOfErrorTableHeader.setBackground(CommonGuiConstant.COLOR_BLACK);
        inCaseOfErrorTableHeader.setForeground(CommonGuiConstant.COLOR_WHITE);
        errorTablePanel.add(inCaseOfErrorTableHeader);
        errorTablePanel.add(inCaseOfErrorTable);
        int errorTablePanelHeight = (int)errorTablePanel.getPreferredSize().getHeight() + 50;
        errorTablePanel.setPreferredSize(new Dimension(1835, errorTablePanelHeight));
        errorTablePanel.setBackground(CommonGuiConstant.COLOR_WHITE);
        int inCaseOfErrorMainPanelHeight = errorTablePanelHeight + 60;
        inCaseOfErrorMainPanel.setPreferredSize(new Dimension(1835, inCaseOfErrorMainPanelHeight));
        inCaseOfErrorMainPanel.add(inCaseOfErrorLabel);
        inCaseOfErrorMainPanel.add(errorTablePanel);
        inCaseOfErrorMainPanel.setBackground(CommonGuiConstant.COLOR_WHITE);
        helpMainPanel.setPreferredSize(new Dimension(fullScreenPanelWidth, howToUseMainPanelHeight + inCaseOfErrorMainPanelHeight));
        helpMainPanel.add(howToUseMainPanel);
        helpMainPanel.add(inCaseOfErrorMainPanel);
        helpMainPanel.setBackground(CommonGuiConstant.COLOR_WHITE);
        helpBodyPanel.setLayout(new BorderLayout());
        JScrollPane helpMainScrollingArea = new JScrollPane(helpMainPanel, 22, 30);
        helpMainScrollingArea.getVerticalScrollBar().setUnitIncrement(20);
        helpMainScrollingArea.getHorizontalScrollBar().setUnitIncrement(20);
        helpMainScrollingArea.getViewport().addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        helpBodyPanel.add(helpMainScrollingArea);
        helpBodyPanel.setBackground(CommonGuiConstant.COLOR_WHITE);
    }

    private void setFooterPanel(JPanel helpFooterPanel) {
        JLabel footerVersionLabel = new JLabel("v" + OutputVmaVersion.getInstance().getVmaVersion());
        footerVersionLabel.setFont(new Font("Arial", 0, 14));
        footerVersionLabel.setForeground(CommonGuiConstant.COLOR_WHITE);
        helpFooterPanel.setBackground(CommonGuiConstant.COLOR_BLACK);
        helpFooterPanel.setLayout(new FlowLayout(2));
        helpFooterPanel.add(footerVersionLabel);
    }

    private void setItemDescriptionPanel(JPanel itemDescriptionPanel, int calcHelpHtmlWidth) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        try {
            editorPane.setPage(this.calcHelpItemDescription);
        }
        catch (Exception e) {
            CalculationGui.getMessageLogTextArea().setForeground(CommonGuiConstant.COLOR_RED);
            CalculationGui.getMessageLogTextArea().append(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_ERROR_ES000, (Object[])null) + "\n");
            log.error(PropertyUtil.getMessageInfo((MessageCode)MessageCode.ENUM_ERROR_ES000, (Object[])new Object[0]));
            log.error(e.getMessage(), (Throwable)e);
        }
        editorPane.setPreferredSize(new Dimension(calcHelpHtmlWidth, 2140));
        itemDescriptionPanel.add(editorPane);
    }
}

